const mongoose = require('mongoose');
const { logger } = require('../core/logger/logger');

let isConnected = false;

const connectDb = async () => {
  if (isConnected) return;

  mongoose.connection.on('connected', () => {
    isConnected = true;
    logger.info('MongoDB connected');
  });

  mongoose.connection.on('disconnected', () => {
    isConnected = false;
    logger.warn('MongoDB disconnected');
  });

  mongoose.connection.on('error', (err) => {
    logger.error('MongoDB error', { error: err.message });
  });

  await mongoose.connect(process.env.MONGO_URI || 'mongodb://localhost:27017/nodemeta', {
    maxPoolSize: 20,
    serverSelectionTimeoutMS: 5000,
    socketTimeoutMS: 45000,
  });
};

const getConnectionStatus = () => ({
  isConnected,
  readyState: mongoose.connection.readyState
});

module.exports = { connectDb, getConnectionStatus };
