const { logger } = require("./core/logger/logger");

// Required environment variables
const required = ["MONGO_URI", "JWT_SECRET"];

// Required in production only
const requiredInProd = ["RSA_PUBLIC_KEY", "RSA_PRIVATE_KEY"];

// Required for PancakeSwap transaction tracking
const requiredForPancakeswap = [
	"TOKEN_BNB_PAIR",
	"TOKEN_CONTRACT_ADDRESS", 
	"ANKR_BSC"
];

const validateEnv = () => {
	const isProd = process.env.NODE_ENV === "production";
	const missing = [];
	const warnings = [];

	for (const key of required) {
		if (!process.env[key]) {
			missing.push(key);
		}
	}

	if (isProd) {
		for (const key of requiredInProd) {
			if (!process.env[key]) {
				missing.push(key);
			}
		}
	}

	// Check PancakeSwap variables (warn if missing, don't fail)
	for (const key of requiredForPancakeswap) {
		if (!process.env[key]) {
			warnings.push(key);
		}
	}

	if (warnings.length > 0) {
		logger.warn("Missing PancakeSwap environment variables - PancakeSwap tracking will be disabled", { 
			missing: warnings 
		});
	}

	if (missing.length > 0) {
		logger.error("Missing required environment variables", { missing });
		throw new Error(
			`Missing required environment variables: ${missing.join(", ")}`,
		);
	}

	logger.info("Environment validation passed");
};

module.exports = { validateEnv };
