const mongoose = require('mongoose');

const cacheEntrySchema = new mongoose.Schema({
  key: {
    type: String,
    required: true,
    unique: true,
    index: true
  },
  value: {
    type: mongoose.Schema.Types.Mixed,
    required: true
  },
  expiresAt: {
    type: Date
  },
  createdAt: {
    type: Date,
    default: Date.now
  },
  updatedAt: {
    type: Date,
    default: Date.now
  }
}, {
  timestamps: true
});

// TTL index for automatic cleanup of expired entries
cacheEntrySchema.index({ expiresAt: 1 }, {
  expireAfterSeconds: 0,
  partialFilterExpression: { expiresAt: { $exists: true } }
});

// Update updatedAt on save
cacheEntrySchema.pre('save', function(next) {
  this.updatedAt = new Date();
  next();
});

const CacheEntry = mongoose.model('CacheEntry', cacheEntrySchema);

module.exports = { CacheEntry };