const { cacheService } = require("../cache/cache.service");
const { rateLimitConfig } = require("../../config/rateLimit.config");

const rateLimitService = {
	async attempt(identifier, { windowSeconds, max }) {
		const key = `rl:${identifier}:${windowSeconds}`;
		const count = await cacheService.increment(key, windowSeconds);
		return {
			blocked: count > max,
			remaining: Math.max(max - count, 0),
			resetSeconds: windowSeconds,
		};
	},

	getPolicy(type = "default") {
		return rateLimitConfig[type] || rateLimitConfig.default;
	},
};

module.exports = { rateLimitService };
