const { cacheService } = require("../cache/cache.service");
const { ApiError } = require("../../utils/ApiError");

const TTL = 300; // 5min replay window

const nonceService = {
	async validateAndStore({ nonce, userId, timestamp, ttlSeconds = TTL }) {
		if (!nonce || !timestamp)
			throw new ApiError(400, "Nonce and timestamp required");

		const age = Date.now() - Number(timestamp);
		if (Number.isNaN(age) || age < 0 || age > ttlSeconds * 1000) {
			throw new ApiError(400, "Stale or invalid timestamp");
		}

		const key = `nonce:${userId || "anon"}:${nonce}`;
		if (await cacheService.exists(key))
			throw new ApiError(409, "Replay detected");

		await cacheService.set(key, true, ttlSeconds);
	},
};

module.exports = { nonceService };
