const crypto = require("crypto");
const { rsaConfig } = require("../../config/rsa.config");
const { ApiError } = require("../../utils/ApiError");

const rsaService = {
	sign(payload) {
		if (!rsaConfig.privateKey)
			throw new ApiError(500, "Signing key not configured");
		const signer = crypto.createSign(rsaConfig.algorithm);
		signer.update(payload);
		signer.end();
		return signer.sign(
			{ key: rsaConfig.privateKey, passphrase: rsaConfig.passphrase },
			"base64",
		);
	},

	verify(payload, signature) {
		if (!rsaConfig.publicKey) return false;
		const verifier = crypto.createVerify(rsaConfig.algorithm);
		verifier.update(payload);
		verifier.end();
		return verifier.verify(rsaConfig.publicKey, signature, "base64");
	},
};

module.exports = { rsaService };
