const { sessionService } = require("./session.service");
const { logger } = require("../logger/logger");

const sessionMiddleware = async (req, res, next) => {
	try {
		const sessionId = await sessionService.ensureSession(
			req.headers["x-session-id"],
		);
		req.sessionId = sessionId;
		res.setHeader("X-Session-Id", sessionId);
		next();
	} catch (err) {
		logger.warn("Session middleware error", { error: err.message });
		next(); // Continue without session
	}
};

module.exports = { sessionMiddleware };
