const { v4: uuidv4, validate: isUuid } = require("uuid");
const { cacheService } = require("../cache/cache.service");

const SESSION_TTL = 60 * 60 * 12;

const sessionService = {
	async ensureSession(sessionId) {
		// Validate UUID format to prevent injection
		if (
			sessionId &&
			isUuid(sessionId) &&
			(await cacheService.exists(`session:${sessionId}`))
		) {
			await cacheService.set(`session:${sessionId}`, true, SESSION_TTL);
			return sessionId;
		}
		const newId = uuidv4();
		await cacheService.set(`session:${newId}`, true, SESSION_TTL);
		return newId;
	},
};

module.exports = { sessionService };
