const ipMiddleware = (req, res, next) => {
	let ip =
		req.headers["x-forwarded-for"]?.split(",")[0].trim() ||
		req.headers["x-real-ip"] ||
		req.socket.remoteAddress;
	if (ip?.startsWith("::ffff:")) ip = ip.substring(7);
	req.clientIp = ip || "unknown";
	next();
};

module.exports = { ipMiddleware };
