const { logger } = require("../core/logger/logger");

const ALLOWED_ORIGINS = process.env.ALLOWED_ORIGINS
	? process.env.ALLOWED_ORIGINS.split(",")
	: ["web", "mobile", "admin", "api"];

const originMiddleware = (req, res, next) => {
	const origin = req.headers["x-origin"];

	if (!origin) {
		logger.warn("Missing X-Origin", { requestId: req.requestId });
		return res.status(400).json({
			error: { message: "X-Origin header required", code: "MISSING_ORIGIN" },
		});
	}

	if (!ALLOWED_ORIGINS.includes(origin.toLowerCase())) {
		logger.warn("Invalid X-Origin", { origin, requestId: req.requestId });
		return res.status(400).json({
			error: {
				message: `Invalid origin. Allowed: ${ALLOWED_ORIGINS.join(", ")}`,
				code: "INVALID_ORIGIN",
			},
		});
	}

	req.origin = origin.toLowerCase();
	next();
};

module.exports = { originMiddleware };
