const { v4: uuidv4 } = require("uuid");

const requestIdMiddleware = (req, res, next) => {
	let requestId = req.headers["x-request-id"]?.trim();
	if (requestId && !/^[a-zA-Z0-9-]{1,64}$/.test(requestId)) requestId = null;
	if (!requestId) requestId = uuidv4();

	req.requestId = requestId;
	res.setHeader("X-Request-Id", requestId);
	next();
};

module.exports = { requestIdMiddleware };
