const { signatureService } = require("../core/security/signature.service");
const { logger } = require("../core/logger/logger");

const signatureMiddleware = async (req, res, next) => {
	try {
		const result = await signatureService.verifyRequestSignature(req);
		req.payloadHash = result.payloadHash;
		next();
	} catch (err) {
		const userId = req.user ? req.user._id : null;
		const ctx = {
			requestId: req.requestId,
			userId,
			ip: req.clientIp,
			endpoint: req.originalUrl,
			error: err.message,
		};

		if (err.statusCode === 409) logger.error("Replay attack", ctx);
		else if (err.statusCode === 400)
			logger.warn("Signature missing headers", ctx);
		else logger.error("Signature verification failed", ctx);

		next(err);
	}
};

module.exports = { signatureMiddleware };
