const mongoose = require('mongoose');

const adminConfigSchema = new mongoose.Schema(
  {
    type: {
      type: String,
      required: true,
      unique: true,
      trim: true,
      index: true,
    },
    note: {
      type: String,
      required: true,
      trim: true,
    },
    passwordHash: {
      type: String,
      required: true,
    },
  },
  {
    timestamps: true,
    collection: 'admin_config',
  }
);

const AdminConfig = mongoose.model('AdminConfig', adminConfigSchema);

module.exports = { AdminConfig };
