const mongoose = require('mongoose');

const adminOverrideSchema = new mongoose.Schema(
  {
    type: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    value: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    setBy: {
      type: String,
      required: true,
      trim: true,
      default: 'admin',
    },
    setAt: {
      type: Date,
      required: true,
      default: Date.now,
      index: true,
    },
    expiresAt: {
      type: Date,
      required: true,
      index: true,
    },
    durationMinutes: {
      type: Number,
      required: true,
      min: 0,
    },
    reason: {
      type: String,
      required: true,
      trim: true,
    },
    isActive: {
      type: Boolean,
      required: true,
      default: true,
      index: true,
    },
    deactivatedAt: {
      type: Date,
      default: null,
    },
    deactivatedBy: {
      type: String,
      default: null,
      trim: true,
    },
    deactivationReason: {
      type: String,
      default: null,
      trim: true,
    },
    version: {
      type: Number,
      required: true,
      default: 1,
      min: 1,
    },
  },
  {
    timestamps: true,
    collection: 'admin_overrides',
  }
);

adminOverrideSchema.index({ type: 1, isActive: 1 });
adminOverrideSchema.index({ isActive: 1, expiresAt: 1 });

const AdminOverride = mongoose.model('AdminOverride', adminOverrideSchema);

module.exports = { AdminOverride };
