const mongoose = require('mongoose');

const adminSystemSettingsSchema = new mongoose.Schema(
  {
    type: {
      type: String,
      required: true,
      unique: true,
      default: 'system_config',
    },
    withdrawalsEnabled: {
      type: Boolean,
      required: true,
      default: true,
    },
    withdrawalsMessage: {
      type: String,
      default: '',
      trim: true,
    },
    purchaseEnabled: {
      type: Boolean,
      required: true,
      default: true,
    },
    purchaseMessage: {
      type: String,
      default: '',
      trim: true,
    },
    userRegistrationEnabled: {
      type: Boolean,
      required: true,
      default: true,
    },
    registrationMessage: {
      type: String,
      default: '',
      trim: true,
    },
    maintenanceMode: {
      type: Boolean,
      required: true,
      default: false,
    },
    maintenanceMessage: {
      type: String,
      default: '',
      trim: true,
    },
    dashboardMaintenanceMode: {
      type: Boolean,
      required: true,
      default: false,
    },
    dashboardMaintenanceMessage: {
      type: String,
      default: '',
      trim: true,
    },
    cronJobInProgress: {
      type: mongoose.Schema.Types.Mixed,
      default: null,
    },
    cronJobStartedAt: {
      type: mongoose.Schema.Types.Mixed,
      default: null,
    },
    lastUpdatedBy: {
      type: String,
      trim: true,
      default: 'SYSTEM',
    },
    lastUpdatedAt: {
      type: Date,
      default: Date.now,
    },
    lastCronJobCompleted: {
      type: String,
      trim: true,
      default: '',
    },
    lastCronJobCompletedAt: {
      type: Date,
      default: Date.now,
    },
    // CRITICAL #12: Store last claim approval time in database (not memory)
    lastClaimApprovalTime: {
      type: Date,
      default: null,
    },
    lastClaimApprovalBy: {
      type: String,
      trim: true,
      default: null,
    },
    // CRITICAL #11: Queue pause enforcement for manual approvals
    queuePaused: {
      type: Boolean,
      default: false,
    },
    queuePausedReason: {
      type: String,
      trim: true,
      default: null,
    },
    queuePausedBy: {
      type: String,
      trim: true,
      default: null,
    },
    queuePausedAt: {
      type: Date,
      default: null,
    },
    allowManualOverrideDuringPause: {
      type: Boolean,
      default: false,
    },
  },
  {
    timestamps: true,
    collection: 'admin_system_settings',
  }
);

const AdminSystemSettings = mongoose.model('AdminSystemSettings', adminSystemSettingsSchema);

module.exports = { AdminSystemSettings };
