const express = require("express");
const router = express.Router();
const tokenStatsController = require("./tokenStats.controller");
const { secure } = require("../../middlewares/security.middleware");

// All token stats routes require admin access

// Get all tokens with pagination and filtering
router.get(
	"/",
	...secure("AR", { role: "admin" }),
	tokenStatsController.getAllTokens,
);

// Get cache statistics
router.get(
	"/stats",
	...secure("AR", { role: "admin" }),
	tokenStatsController.getCacheStats,
);

// Get sessions for a specific user
router.get(
	"/user/:username",
	...secure("AR", { role: "admin" }),
	tokenStatsController.getUserSessions,
);

// Cleanup expired tokens
router.post(
	"/cleanup",
	...secure("AR", { role: "admin" }),
	tokenStatsController.cleanupExpiredTokens,
);

// Force logout specific user(s)
router.post(
	"/force-logout",
	...secure("AR", { role: "admin" }),
	tokenStatsController.forceLogoutUser,
);

// Force logout ALL users (nuclear option)
router.post(
	"/force-logout-all",
	...secure("AR", { role: "admin" }),
	tokenStatsController.forceLogoutAllUsers,
);

// Invalidate token(s) - legacy endpoint
router.delete(
	"/",
	...secure("AR", { role: "admin" }),
	tokenStatsController.invalidateToken,
);

module.exports = tokenStatsRoutes = router;
