const mongoose = require('mongoose');

const blogSchema = new mongoose.Schema(
  {
    title: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    subtitle: {
      type: String,
      required: true,
      trim: true,
    },
    description: {
      type: String,
      required: true,
      trim: true,
    },
    content: {
      type: String,
      required: true,
    },
    category: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    author: {
      type: String,
      required: true,
      trim: true,
      default: 'NodeMeta Team',
    },
    image: {
      type: String,
      required: true,
      trim: true,
    },
    slug: {
      type: String,
      required: true,
      trim: true,
      unique: true,
      index: true,
    },
    date: {
      type: String,
      required: true,
      trim: true,
    },
    readTime: {
      type: String,
      required: true,
      trim: true,
    },
    views: {
      type: Number,
      required: true,
      default: 0,
      min: 0,
    },
    likes: {
      type: Number,
      required: true,
      default: 0,
      min: 0,
    },
    likedBy: {
      type: [String],
      required: true,
      default: [],
    },
    featured: {
      type: Boolean,
      required: true,
      default: false,
      index: true,
    },
    active: {
      type: Boolean,
      required: true,
      default: true,
      index: true,
    },
  },
  {
    timestamps: true,
    collection: 'blogs',
  }
);

blogSchema.index({ category: 1, active: 1 });
blogSchema.index({ featured: -1, createdAt: -1 });

const Blog = mongoose.model('Blog', blogSchema);

module.exports = { Blog };
