const mongoose = require("mongoose");

const commentSchema = new mongoose.Schema(
	{
		blogId: {
			type: mongoose.Schema.Types.ObjectId,
			required: true,
			index: true,
			ref: "Blog",
		},
		userId: {
			type: String,
			required: false,
			trim: true,
			index: true,
			default: "anonymous",
		},
		author: {
			type: String,
			required: true,
			trim: true,
		},
		text: {
			type: String,
			required: true,
			trim: true,
		},
		parentId: {
			type: mongoose.Schema.Types.ObjectId,
			required: false,
			default: null,
		},
		hidden: {
			type: Boolean,
			required: true,
			default: false,
		},
	},
	{
		timestamps: true,
		collection: "comments",
	},
);

commentSchema.index({ blogId: 1, createdAt: -1 });
commentSchema.index({ userId: 1, createdAt: -1 });

const Comment = mongoose.model("Comment", commentSchema);

module.exports = { Comment };
