const { bonusDistributionService } = require("./bonusDistribution.service");
const { ApiResponse } = require("../../utils/ApiResponse");

const bonusDistributionController = {
	async getDistributionHistory(req, res, next) {
		try {
			const result = await bonusDistributionService.getDistributionHistory(req.query);
			res.json(new ApiResponse(200, result, "Distribution history retrieved successfully"));
		} catch (err) {
			next(err);
		}
	},
};

module.exports = { bonusDistributionController };
