const mongoose = require("mongoose");

const bonusDistributionSchema = new mongoose.Schema(
	{
		username: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		distributionDate: {
			type: String,
			required: true,
			index: true,
		},
		bonusType: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		amountNTE: {
			type: Number,
			required: true,
		},
		amountUSD: {
			type: Number,
			required: true,
		},
		status: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		loggedAt: {
			type: Date,
			required: true,
			default: Date.now,
		},
		metadata: {
			traceId: {
				type: String,
				required: true,
				trim: true,
			},
			triggerType: {
				type: String,
				required: true,
				trim: true,
			},
			baseValue: {
				type: Number,
			},
			blockchainTransaction: {
				fromAddress: String,
				hash: String,
				network: String,
				paymentMethod: String,
				toAddress: String,
				tokenContract: String,
			},
			blockNumber: Number,
			monthKey: String,
			bonusOrigin: String,
			calculationDetails: mongoose.Schema.Types.Mixed,
			calculationMethod: String,
			confirmedAt: Date,
			distributionSummary: [mongoose.Schema.Types.Mixed],
			fromAddress: String,
			gasPrice: String,
			gasUsed: String,
			generation: Number,
			packageId: String,
			packageName: String,
			packagesProcessed: Number,
			packageType: String,
			paymentMethod: String,
			percentage: Number,
			purchaseDistributionId: String,
			purchaserUsername: String,
			referralBonusesProcessed: Number,
			referrersBenefited: Number,
			relatedTransactions: Boolean,
			requestId: mongoose.Schema.Types.Mixed,
			toAddress: String,
			tokenValue: Number,
			totalTransactions: Number,
			transactionHash: String,
			transactionId: String,
			transactionType: String,
			userPackageId: String,
			walletBalanceBefore: Number,
			withdrawalRequestId: mongoose.Schema.Types.ObjectId,
			withdrawalType: String,
		},
	},
	{
		timestamps: false,
		collection: "bonusDistributions",
	},
);

bonusDistributionSchema.index({ username: 1, distributionDate: -1 });
bonusDistributionSchema.index({ bonusType: 1, status: 1 });
bonusDistributionSchema.index({ distributionDate: -1, loggedAt: -1 });

const BonusDistribution = mongoose.model(
	"BonusDistribution",
	bonusDistributionSchema,
);

module.exports = { BonusDistribution };
