const express = require("express");
const {
	bonusDistributionController,
} = require("./bonusDistribution.controller");
const { secure } = require("../../middlewares/security.middleware");

const router = express.Router();

// Admin only - get distribution history with filters, pagination, and stats
router.get(
	"/history",
	...secure("AR", { role: "admin" }),
	bonusDistributionController.getDistributionHistory,
);

module.exports = { bonusDistributionRoutes: router };
