const mongoose = require('mongoose');

const bonusTransactionSchema = new mongoose.Schema(
  {
    userId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'User',
      index: true,
    },
    username: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    bonusType: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    amountNTE: {
      type: Number,
      required: true,
    },
    amountUSD: {
      type: Number,
      required: true,
    },
    distributionId: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: 'BonusDistribution',
    },
    description: {
      type: String,
      required: true,
      trim: true,
    },
    status: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    generatedBy: {
      type: String,
      trim: true,
    },
    transactionType: {
      type: String,
      trim: true,
    },
    processedAt: {
      type: Date,
    },
    metadata: {
      traceId: {
        type: String,
        required: true,
        trim: true,
      },
      baseValue: Number,
      blockchainTransaction: {
        fromAddress: String,
        hash: String,
        network: String,
        paymentMethod: String,
        toAddress: String,
        tokenContract: String,
      },
      blockNumber: Number,
      bonusOrigin: String,
      calculationDetails: mongoose.Schema.Types.Mixed,
      confirmedAt: Date,
      distributionId: mongoose.Schema.Types.ObjectId,
      fromAddress: String,
      gasPrice: String,
      gasUsed: String,
      generation: Number,
      packageId: String,
      packageName: String,
      packageType: String,
      paymentMethod: String,
      percentage: Number,
      purchaseDistributionId: String,
      purchaserUsername: String,
      requestId: mongoose.Schema.Types.Mixed,
      toAddress: String,
      tokenValue: Number,
      transactionHash: String,
      transactionId: String,
      triggerType: String,
      userPackageId: String,
      walletBalanceBefore: Number,
      withdrawalRequestId: mongoose.Schema.Types.ObjectId,
      withdrawalType: String,
    },
  },
  {
    timestamps: true,
    collection: 'bonusTransactions',
  }
);

bonusTransactionSchema.index({ userId: 1, createdAt: -1 });
bonusTransactionSchema.index({ username: 1, bonusType: 1 });
bonusTransactionSchema.index({ bonusType: 1, status: 1 });
bonusTransactionSchema.index({ distributionId: 1 });

const BonusTransaction = mongoose.model('BonusTransaction', bonusTransactionSchema);

module.exports = { BonusTransaction };
