const express = require('express');
const { bonusTransactionController } = require('./bonusTransaction.controller');
const { secure } = require('../../middlewares/security.middleware');

const router = express.Router();

router.get(
	'/history',
	...secure('AR', { role: 'admin' }),
	bonusTransactionController.getTransactionHistory,
);

// Public/Authenticated routes
router.get('/', ...secure('AR'), bonusTransactionController.listBonusTransactions);
router.get('/:id/:type', ...secure('AR'), bonusTransactionController.getBonusTransactionById);

// final bonus claim processing route
router.post('/claim-final-bonus', ...secure('AR'), bonusTransactionController.processEnhancedFinalBonusClaim);

module.exports = { bonusTransactionRoutes: router };
