const express = require("express");
const claimRequestController = require("./claimRequest.controller");
const { secure } = require("../../middlewares/security.middleware");

const router = express.Router();

router.post("/", secure("AR"), claimRequestController.createClaimRequest);
router.post("/validate", secure("AR"), claimRequestController.validateClaimRequest);
router.get("/queue-status/:claimRequestId", secure("AR"), claimRequestController.getQueueStatus);
router.get("/my-claims", secure("AR"), claimRequestController.getUserClaims);

router.get("/", secure("AR", { role: "admin" }), claimRequestController.getClaimRequests);
router.get("/verify-claim", secure("AR", { role: "admin" }), claimRequestController.verifyClaimRequest);
router.post("/approve", secure("AR", { role: "admin" }), claimRequestController.approveClaimRequest);
router.post("/reject", secure("AR", { role: "admin" }), claimRequestController.rejectClaimRequest);

router.get("/queue/stats", secure("AR", { role: "admin" }), claimRequestController.getQueueStats);
router.get("/queue/pending", secure("AR", { role: "admin" }), claimRequestController.getPendingQueue);
router.get("/queue/history", secure("AR", { role: "admin" }), claimRequestController.getQueueHistory);
router.get("/queue/failed", secure("AR", { role: "admin" }), claimRequestController.getFailedClaims);
router.get("/queue/manual-review", secure("AR", { role: "admin" }), claimRequestController.getManualReviewClaims);

router.post("/queue/retry/:claimRequestId", secure("AR", { role: "admin" }), claimRequestController.retryFailedClaim);
router.post("/queue/skip/:claimRequestId", secure("AR", { role: "admin" }), claimRequestController.skipClaim);
router.post("/queue/prioritize/:claimRequestId", secure("AR", { role: "admin" }), claimRequestController.prioritizeClaim);
router.post("/queue/mark-manual/:claimRequestId", secure("AR", { role: "admin" }), claimRequestController.markForManualReview);
router.post("/queue/clear-manual/:claimRequestId", secure("AR", { role: "admin" }), claimRequestController.clearManualReview);
router.post("/queue/pause", secure("AR", { role: "admin" }), claimRequestController.pauseQueue);
router.post("/queue/resume", secure("AR", { role: "admin" }), claimRequestController.resumeQueue);
router.post("/queue/refresh-positions", secure("AR", { role: "admin" }), claimRequestController.refreshQueuePositions);

module.exports = router;
