const express = require('express');
const { globalConfigController } = require('./globalConfig.controller');
const { secure } = require('../../middlewares/security.middleware');

const router = express.Router();

// token prices
router.get('/token-prices', globalConfigController.fetchAllTokenPrices);

// Get all global configurations
router.get('/', ...secure('AR', { role: 'admin' }), globalConfigController.getAllConfigs);

// Get specific configuration by key
router.get('/:key', ...secure('AR', { role: 'admin' }), globalConfigController.getConfigByKey);

// Update configuration 
router.put('/:key', ...secure('AR', { role: 'admin' }), globalConfigController.updateConfig);

// Clear all caches
router.post('/cache/clear', ...secure('AR', { role: 'admin' }), globalConfigController.clearCaches);

// Initialize default configurations 
router.post('/initialize', ...secure('AR', { role: 'admin' }), globalConfigController.initializeDefaults);


module.exports = router;
