const dbeProgramService = require("./dbeProgram.service");
const { ApiResponse } = require("../../utils/ApiResponse");
const { ApiError } = require("../../utils/ApiError");

class DbeProgramController {
	/**
	 * Get all DBE programs
	 */
	async getAllPrograms(req, res, next) {
		try {
			const activeOnly = req.query.activeOnly === "true";

			const programs = await dbeProgramService.getAllPrograms({ activeOnly });

			res
				.status(200)
				.json(
					new ApiResponse(200, programs, "DBE programs retrieved successfully")
				);
		} catch (error) {
			next(error);
		}
	}

	/**
	 * Get DBE program by ID
	 */
	async getProgramById(req, res, next) {
		try {
			const { id } = req.params;

			const program = await dbeProgramService.getProgramById(id);

			res
				.status(200)
				.json(
					new ApiResponse(200, program, "DBE program retrieved successfully")
				);
		} catch (error) {
			next(error);
		}
	}

	/**
	 * Create a new DBE program
	 */
	async createProgram(req, res, next) {
		try {
			const program = await dbeProgramService.createProgram(req.body);

			res
				.status(201)
				.json(new ApiResponse(201, program, "DBE program created successfully"));
		} catch (error) {
			next(error);
		}
	}

	/**
	 * Update a DBE program
	 */
	async updateProgram(req, res, next) {
		try {
			const { id } = req.params;

			const program = await dbeProgramService.updateProgram(id, req.body);

			res
				.status(200)
				.json(new ApiResponse(200, program, "DBE program updated successfully"));
		} catch (error) {
			next(error);
		}
	}

	/**
	 * Toggle DBE program status
	 */
	async toggleProgramStatus(req, res, next) {
		try {
			const { id } = req.params;
			const { isActive } = req.body;

			const program = await dbeProgramService.toggleProgramStatus(id, isActive);

			res
				.status(200)
				.json(
					new ApiResponse(200, program, "DBE program status updated successfully")
				);
		} catch (error) {
			next(error);
		}
	}

	/**
	 * Delete a DBE program
	 */
	async deleteProgram(req, res, next) {
		try {
			const { id } = req.params;

			const result = await dbeProgramService.deleteProgram(id);

			res.status(200).json(new ApiResponse(200, result, result.message));
		} catch (error) {
			next(error);
		}
	}
}

module.exports = new DbeProgramController();
