const mongoose = require('mongoose');

const dbeProgramSchema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: true,
      trim: true,
    },
    packageType: {
      type: String,
      default: 'dbe',
      trim: true,
    },
    durationDays: {
      type: Number,
      required: true,
    },
    minimumBuyAmount: {
      type: Number,
      required: true,
      default: 0,
    },
    price: {
      startUSD: {
        type: Number,
        default: 0,
      },
      fixedUSD: {
        type: Number,
        default: 0,
      },
      countForPriceIncrease: {
        type: Number,
        default: 0,
      },
      increaseSalePriceUSD: {
        type: Number,
        default: 0,
      },
    },
    reserveWalletAddress: {
      type: String,
      required: true,
      trim: true,
    },
    maxUsers: {
      type: Number,
      default: null,
    },
    isActive: {
      type: Boolean,
      default: true,
    },
    bonusClaim: {
      frequency: {
        type: String,
        default: 'after_lock_period',
        trim: true,
      },
    },
    userBonusCalculation: {
      bonusPercent: {
        type: Number,
        required: true,
      },
    },
    referralBonusImmediate: {
      firstGenPercent: {
        type: Number,
        default: 0,
      },
      secondGenPercent: {
        type: Number,
        default: 0,
      },
      othersGenPercent: {
        type: Number,
        default: 0,
      },
    },
    referralBonusCalculation: {
      type: mongoose.Schema.Types.Mixed,
      default: null,
    },
  },
  {
    timestamps: true,
    collection: 'dbe_programs',
  }
);

dbeProgramSchema.index({ packageType: 1, isActive: 1 });
dbeProgramSchema.index({ durationDays: 1 });

const DbeProgram = mongoose.model('DbeProgram', dbeProgramSchema);

module.exports = { DbeProgram };
