const express = require("express");
const dbeProgramController = require("./dbeProgram.controller");
const { secure } = require("../../middlewares/security.middleware");

const router = express.Router();

// Public routes (with auth)
router.get("/", secure("AR"), dbeProgramController.getAllPrograms);
router.get("/:id", secure("AR"), dbeProgramController.getProgramById);

// Admin routes
router.post("/", secure("AR", { role: "admin" }), dbeProgramController.createProgram);
router.put("/:id", secure("AR", { role: "admin" }), dbeProgramController.updateProgram);
router.put("/:id/status", secure("AR", { role: "admin" }), dbeProgramController.toggleProgramStatus);
router.delete("/:id", secure("AR", { role: "admin" }), dbeProgramController.deleteProgram);

module.exports = router;
