const mongoose = require('mongoose');

const dbeProgramAttendeeSchema = new mongoose.Schema(
  {
    programId: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: 'DbeProgram',
      index: true,
    },
    username: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    feeUSD: {
      type: Number,
      required: true,
    },
    feeNTE: {
      type: Number,
      required: true,
    },
    tokenPriceAtJoining: {
      type: Number,
      required: true,
    },
    purchasedAt: {
      type: Date,
      required: true,
    },
    startDate: {
      type: Date,
      required: true,
      index: true,
    },
    endDate: {
      type: Date,
      required: true,
      index: true,
    },
    status: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    blockchainTransactionHash: {
      type: String,
      required: true,
      trim: true,
    },
    blockchainTransaction: {
      hash: {
        type: String,
        required: true,
        trim: true,
      },
      network: {
        type: String,
        required: true,
        trim: true,
      },
      fromAddress: {
        type: String,
        required: true,
        trim: true,
      },
      toAddress: {
        type: String,
        required: true,
        trim: true,
      },
      tokenContract: {
        type: String,
        required: true,
        trim: true,
      },
      traceId: {
        type: String,
        required: true,
        trim: true,
      },
      verifiedAt: {
        type: Date,
        required: true,
      },
    },
    metadata: {
      traceId: {
        type: String,
        required: true,
        trim: true,
      },
      transactionId: {
        type: String,
        required: true,
        trim: true,
      },
      creationMethod: {
        type: String,
        required: true,
        trim: true,
      },
    },
    dailyLogs: [
      {
        date: {
          type: String,
          required: true,
          trim: true,
        },
        checkedAt: {
          type: String,
          required: true,
          trim: true,
        },
        isCompliant: {
          type: Boolean,
          required: true,
        },
        disqualificationReason: {
          type: String,
          required: true,
          trim: true,
        },
        minimumRequired: {
          type: Number,
          required: true,
        },
        totalBuyNTE: {
          type: Number,
          required: true,
        },
        totalSellNTE: {
          type: Number,
          required: true,
        },
        totalTransferInNTE: {
          type: Number,
          required: true,
        },
        totalTransferOutNTE: {
          type: Number,
          required: true,
        },
        transactionSummary: {
          totalTransactions: {
            type: Number,
            required: true,
          },
          hasBuy: {
            type: Boolean,
            required: true,
          },
          hasSell: {
            type: Boolean,
            required: true,
          },
          hasTransferIn: {
            type: Boolean,
            required: true,
          },
          hasTransferOut: {
            type: Boolean,
            required: true,
          },
        },
      },
    ],
    disqualifiedAt: {
      type: Date,
    },
    disqualificationReason: {
      type: String,
      trim: true,
    },
  },
  {
    timestamps: true,
    collection: 'dbe_program_attendees',
  }
);

dbeProgramAttendeeSchema.index({ programId: 1, status: 1 });
dbeProgramAttendeeSchema.index({ username: 1, startDate: -1 });

const DbeProgramAttendee = mongoose.model('DbeProgramAttendee', dbeProgramAttendeeSchema);

module.exports = { DbeProgramAttendee };
