const express = require("express");
const router = express.Router();
const dbeProgramAttendeeController = require("./dbeProgramAttendee.controller");
const { secure } = require("../../middlewares/security.middleware");

// Get all DBE program attendees for a user
router.get(
	"/user/:username",
	secure("AR"),
	dbeProgramAttendeeController.getUserAttendances,
);

// Get all attendees for a specific DBE program
router.get(
	"/program/:programId",
	secure("AR", { role: "admin" }),
	dbeProgramAttendeeController.getProgramAttendees,
);

// Get attendance by ID
router.get(
	"/:attendanceId",
	secure("AR", { role: "admin" }),
	dbeProgramAttendeeController.getAttendanceById,
);

// Update attendance status
router.put(
	"/:attendanceId/status",
	secure("AR", { role: "admin" }),
	dbeProgramAttendeeController.updateAttendanceStatus,
);

// Get all active attendances
router.get(
	"/active",
	secure("AR", { role: "admin" }),
	dbeProgramAttendeeController.getActiveAttendances,
);

// Get all DBE attendances with advanced filtering
router.get(
	"/",
	secure("AR", { role: "admin" }),
	dbeProgramAttendeeController.getAllAttendances,
);

module.exports = router;
