const mongoose = require("mongoose");

const failedPurchaseSchema = new mongoose.Schema(
	{
		username: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		transactionHash: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		fromAddress: {
			type: String,
			required: true,
			trim: true,
		},
		selectedPackage: {
			type: mongoose.Schema.Types.ObjectId,
			ref: 'Product',
			required: true,
			index: true,
		},
		quantity: {
			type: Number,
			required: true,
		},
		priceUSD: {
			type: Number,
			required: true,
		},
		priceNTE: {
			type: Number,
			required: true,
		},
		errorMessage: {
			type: String,
			required: true,
			trim: true,
		},
		status: {
			type: String,
			required: true,
			trim: true,
		},
		submittedAt: {
			type: Date,
			required: true,
			index: true,
		},
		processedAt: {
			type: Date,
		},
		adminMessage: {
			type: String,
			trim: true,
		},
		adminMessageAt: {
			type: Date,
		},
	},
	{
		timestamps: true,
		collection: "failedPurchases",
	},
);

failedPurchaseSchema.index({ username: 1, submittedAt: -1 });
failedPurchaseSchema.index({ selectedPackage: 1, submittedAt: -1 });

const FailedPurchase = mongoose.model("FailedPurchase", failedPurchaseSchema);

module.exports = { FailedPurchase };
