const express = require('express');
const { failedPurchaseController } = require('./failedPurchase.controller');
const { secure } = require('../../middlewares/security.middleware');

const router = express.Router();

// Authenticated routes - users can submit and view their own failed purchases
router.post(
  '/',
  ...secure('AR'),
  failedPurchaseController.createFailedPurchase
);

router.get(
  '/my-purchases',
  ...secure('AR'),
  failedPurchaseController.getMyFailedPurchases
);

// Admin routes - require authentication
router.get(
  '/',
  ...secure('AR', { role: 'admin' }),
  failedPurchaseController.listFailedPurchases
);

router.get(
  '/statistics',
  ...secure('AR', { role: 'admin' }),
  failedPurchaseController.getStatistics
);

router.post(
  '/validate-manual-purchase/:id',
  ...secure('AR', { role: 'admin' }),
  failedPurchaseController.validateManualPurchase
);

router.get(
  '/username/:username',
  ...secure('AR', { role: 'admin' }),
  failedPurchaseController.getFailedPurchasesByUsername
);

router.get(
  '/tx/:txHash',
  ...secure('AR', { role: 'admin' }),
  failedPurchaseController.getFailedPurchaseByTxHash
);

router.get(
  '/:id',
  ...secure('AR', { role: 'admin' }),
  failedPurchaseController.getFailedPurchaseById
);

router.patch(
  '/:id/status',
  ...secure('AR', { role: 'admin' }),
  failedPurchaseController.updateFailedPurchaseStatus
);

router.put(
  '/:id',
  ...secure('AR', { role: 'admin' }),
  failedPurchaseController.updateFailedPurchase
);

router.delete(
  '/:id',
  ...secure('AR', { role: 'admin' }),
  failedPurchaseController.deleteFailedPurchase
);

module.exports = { failedPurchaseRoutes: router };
