const mongoose = require("mongoose");

const newsSchema = new mongoose.Schema(
	{
		title: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		description: {
			type: String,
			required: true,
			trim: true,
		},
		date: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		type: {
			type: String,
			required: true,
			trim: true,
			index: true,
			default: "public",
		},
		active: {
			type: Boolean,
			required: true,
			index: true,
		},
		isEmergency: {
			type: Boolean,
		},
	},
	{
		timestamps: true,
		collection: "news",
	},
);

newsSchema.index({ active: 1, date: -1 });

const News = mongoose.model("News", newsSchema);

module.exports = { News };
