const express = require('express');
const { newsController } = require('./news.controller');
const { secure } = require('../../middlewares/security.middleware');

const router = express.Router();

// Public routes - anyone can access
router.get('/', newsController.listNews);
router.get('/all-news', ...secure('AR', { role: 'admin' }), newsController.listNews);
router.get('/:id', newsController.getNewsById);

// Admin only routes
router.post('/', ...secure('AR', { role: 'admin' }), newsController.createNews);
router.put('/:id', ...secure('AR', { role: 'admin' }), newsController.updateNews);
router.delete('/:id', ...secure('AR', { role: 'admin' }), newsController.deleteNews);
router.patch('/:id/status', ...secure('AR', { role: 'admin' }), newsController.toggleNewsStatus);
router.patch('/:id/emergency', ...secure('AR', { role: 'admin' }), newsController.toggleEmergencyStatus);

module.exports = { newsRoutes: router };
