const mongoose = require('mongoose');

const newsletterSubscriberSchema = new mongoose.Schema(
  {
    email: {
      type: String,
      required: true,
      trim: true,
      unique: true,
      index: true,
    },
    name: {
      type: String,
      trim: true,
    },
    phone: {
      type: String,
      trim: true,
    },
    interests: {
      type: String,
      trim: true,
    },
    active: {
      type: Boolean,
      required: true,
      index: true,
    },
  },
  {
    timestamps: true,
    collection: 'newsletter-subscribers',
  }
);

newsletterSubscriberSchema.index({ active: 1, createdAt: -1 });

const NewsletterSubscriber = mongoose.model('NewsletterSubscriber', newsletterSubscriberSchema);

module.exports = { NewsletterSubscriber };
