const express = require('express');
const { newsletterController } = require('./newsletterSubscriber.controller');
const { secure } = require('../../middlewares/security.middleware');

const router = express.Router();

// Public route - anyone can subscribe
router.post('/subscribe', newsletterController.subscribe);

// Admin only routes
router.get('/', ...secure('AR', { role: 'admin' }), newsletterController.listSubscribers);
router.get('/:id', ...secure('AR', { role: 'admin' }), newsletterController.getSubscriberById);
router.put('/:id', ...secure('AR', { role: 'admin' }), newsletterController.updateSubscriber);
router.delete('/:id', ...secure('AR', { role: 'admin' }), newsletterController.deleteSubscriber);
router.patch('/:id/status', ...secure('AR', { role: 'admin' }), newsletterController.toggleSubscriberStatus);

module.exports = { newsletterRoutes: router };
