const mongoose = require("mongoose");

const emailSchema = new mongoose.Schema(
	{
		from: {
			type: String,
			required: true,
		},
		to: {
			type: [String],
			required: true,
		},
		cc: {
			type: [String],
			default: [],
		},
		bcc: {
			type: [String],
			default: [],
		},
		subject: {
			type: String,
			required: true,
		},
		text: {
			type: String,
		},
		html: {
			type: String,
		},
		contentType: {
			type: String,
			enum: ["text", "html"],
			default: "text",
		},
		messageId: {
			type: String,
		},
		status: {
			type: String,
			enum: ["pending", "sent", "failed"],
			default: "pending",
		},
		sentAt: {
			type: Date,
		},
		failedAt: {
			type: Date,
		},
		error: {
			type: String,
		},
		accepted: {
			type: [String],
		},
		rejected: {
			type: [String],
		},
		sentBy: {
			type: String,
		},
		isBulk: {
			type: Boolean,
			default: false,
		},
		bulkId: {
			type: String,
		},
		bulkJobId: {
			type: String,
		},
		bulkRecipientCount: {
			type: Number,
		},
		bulkSentCount: {
			type: Number,
			default: 0,
		},
		bulkFailedCount: {
			type: Number,
			default: 0,
		},
		bulkProgress: {
			type: String,
			enum: ["pending", "processing", "completed", "failed"],
			default: "pending",
		},
		bulkStartedAt: {
			type: Date,
		},
		bulkCompletedAt: {
			type: Date,
		},
		bulkDuration: {
			type: String,
		},
		bulkBatches: {
			type: Number,
		},
	},
	{
		timestamps: true,
	}
);

emailSchema.index({ status: 1, createdAt: -1 });
emailSchema.index({ to: 1 });
emailSchema.index({ bulkId: 1 });
emailSchema.index({ bulkJobId: 1 });
emailSchema.index({ sentBy: 1 });
emailSchema.index({ bulkProgress: 1 });

const Email = mongoose.model("Email", emailSchema);

module.exports = { Email };
