const express = require("express");
const emailController = require("./email.controller");
const { secure } = require("../../middlewares/security.middleware");

const router = express.Router();

// Email history routes
router.get("/history", secure("AR", { role: "admin" }), emailController.getEmailHistory);
router.get("/bulk/:bulkId", secure("AR", { role: "admin" }), emailController.getBulkEmailStatus);
router.get("/:id", secure("AR", { role: "admin" }), emailController.getEmailById);

// Verify email connection
router.get("/verify", secure("AR", { role: "admin" }), emailController.verifyConnection);

// Send email routes (admin only)
router.post("/send", secure("AR", { role: "admin" }), emailController.sendEmail);
router.post("/send-bulk", secure("AR", { role: "admin" }), emailController.sendBulkEmail);

module.exports = router;
