const mongoose = require("mongoose");

const pushNotificationSchema = new mongoose.Schema(
	{
		bulkNotificationId: {
			type: String,
			required: true,
			unique: true,
			index: true,
		},
		bulkJobId: {
			type: String,
			index: true,
		},
		title: {
			type: String,
			required: true,
		},
		body: {
			type: String,
			required: true,
		},
		payload: {
			type: mongoose.Schema.Types.Mixed,
		},
		icon: {
			type: String,
		},
		badge: {
			type: String,
		},
		image: {
			type: String,
		},
		url: {
			type: String,
		},
		actions: {
			type: [mongoose.Schema.Types.Mixed],
		},
		status: {
			type: String,
			enum: ["pending", "processing", "completed", "failed"],
			default: "pending",
			index: true,
		},
		// Targeting
		targetType: {
			type: String,
			enum: ["all", "user", "users", "segment"],
			default: "all",
		},
		targetUsers: {
			type: [String], // Array of usernames
		},
		// Statistics
		totalUsers: {
			type: Number,
			default: 0,
		},
		totalSubscriptions: {
			type: Number,
			default: 0,
		},
		sentCount: {
			type: Number,
			default: 0,
		},
		failedCount: {
			type: Number,
			default: 0,
		},
		// Processing details
		batchSize: {
			type: Number,
			default: 20,
		},
		batches: {
			type: Number,
		},
		startedAt: {
			type: Date,
		},
		completedAt: {
			type: Date,
		},
		duration: {
			type: String,
		},
		// Metadata
		sentBy: {
			type: String,
		},
		error: {
			type: String,
		},
		metadata: {
			type: mongoose.Schema.Types.Mixed,
			default: {},
		},
	},
	{
		timestamps: true,
		collection: "push_notifications",
	},
);

// Indexes
pushNotificationSchema.index({ status: 1, createdAt: -1 });
pushNotificationSchema.index({ sentBy: 1, createdAt: -1 });
pushNotificationSchema.index({ targetType: 1, status: 1 });

const PushNotification = mongoose.model(
	"PushNotification",
	pushNotificationSchema,
);

module.exports = { PushNotification };
