const mongoose = require("mongoose");

const pushSubscriptionSchema = new mongoose.Schema(
	{
		endpoint: {
			type: String,
			required: true,
			trim: true,
			unique: true,
		},
		username: {
			type: String,
			required: true,
			trim: true,
			index: true,
		},
		userId: {
			type: mongoose.Schema.Types.ObjectId,
			ref: "User",
			index: true,
		},
		subscription: {
			endpoint: {
				type: String,
				required: true,
				trim: true,
			},
			expirationTime: {
				type: mongoose.Schema.Types.Mixed,
				default: null,
			},
			keys: {
				p256dh: {
					type: String,
					required: true,
					trim: true,
				},
				auth: {
					type: String,
					required: true,
					trim: true,
				},
			},
		},
		deviceInfo: {
			browser: {
				type: String,
				trim: true,
			},
			platform: {
				type: String,
				trim: true,
			},
			userAgent: {
				type: String,
				trim: true,
			},
		},
		isActive: {
			type: Boolean,
			required: true,
			default: true,
			index: true,
		},
		lastUsed: {
			type: Date,
			default: Date.now,
		},
		metadata: {
			type: mongoose.Schema.Types.Mixed,
			default: {},
		},
	},
	{
		timestamps: true,
		collection: "push_subscriptions",
	},
);

pushSubscriptionSchema.index({ username: 1, isActive: 1 });
pushSubscriptionSchema.index({ userId: 1, isActive: 1 });

const PushSubscription = mongoose.model(
	"PushSubscription",
	pushSubscriptionSchema,
);

module.exports = { PushSubscription };
