const express = require("express");
const pushSubscriptionController = require("./pushSubscription.controller");
const { secure } = require("../../middlewares/security.middleware");

const router = express.Router();

// User routes
router.get("/", secure("AR"), pushSubscriptionController.getAllSubscriptions);
router.get("/history", secure("AR", { role: "admin" }), pushSubscriptionController.getNotificationHistory);
router.get("/bulk/:bulkId", secure("AR", { role: "admin" }), pushSubscriptionController.getBulkNotificationStatus);
router.get("/user/:username", secure("AR"), pushSubscriptionController.getSubscriptionsByUsername);
router.get("/:id", secure("AR"), pushSubscriptionController.getSubscriptionById);

router.post("/", secure("AR"), pushSubscriptionController.createOrUpdateSubscription);
router.put("/:id/status", secure("AR"), pushSubscriptionController.updateSubscriptionStatus);

router.delete("/:id", secure("AR"), pushSubscriptionController.deleteSubscription);
router.post("/delete-by-endpoint", secure("AR"), pushSubscriptionController.deleteSubscriptionByEndpoint);

// Send notification routes
router.post("/send/:username", secure("AR", { role: "admin" }), pushSubscriptionController.sendNotificationToUser);
router.post("/send-all", secure("AR", { role: "admin" }), pushSubscriptionController.sendNotificationToAll);

// Admin routes
router.delete("/user/:username", secure("AR", { role: "admin" }), pushSubscriptionController.deleteUserSubscriptions);
router.post("/cleanup", secure("AR", { role: "admin" }), pushSubscriptionController.cleanupInactiveSubscriptions);

module.exports = router;
