const mongoose = require('mongoose');

const pancakeswapTransactionSchema = new mongoose.Schema(
  {
    transactionHash: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    blockNumber: {
      type: Number,
      required: true,
      index: true,
    },
    from: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    to: {
      type: String,
      required: true,
      trim: true,
    },
    tokenAddress: {
      type: String,
      required: true,
      trim: true,
    },
    pairAddress: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    type: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    value: {
      type: String,
      required: true,
      trim: true,
    },
    valueFormatted: {
      type: Number,
      required: true,
    },
    tokenAmount: {
      type: Number,
      required: true,
    },
    valueBNB: {
      type: Number,
      required: true,
    },
    valueUSD: {
      type: Number,
      required: true,
    },
    priceBNB: {
      type: Number,
      required: true,
    },
    priceUSD: {
      type: Number,
      required: true,
    },
    swapData: {
      type: mongoose.Schema.Types.Mixed,
      default: null,
    },
    timestamp: {
      type: Date,
      required: true,
      index: true,
    },
    processed: {
      type: Boolean,
      required: true,
    },
    usernameFrom: {
      type: mongoose.Schema.Types.Mixed,
    },
    usernameTo: {
      type: mongoose.Schema.Types.Mixed,
    },
  },
  {
    timestamps: true,
    collection: 'pancakeswap_transactions',
  }
);

pancakeswapTransactionSchema.index({ transactionHash: 1, blockNumber: 1 }, { unique: true });
pancakeswapTransactionSchema.index({ from: 1, timestamp: -1 });
pancakeswapTransactionSchema.index({ pairAddress: 1, timestamp: -1 });
pancakeswapTransactionSchema.index({ type: 1, timestamp: -1 });

const PancakeswapTransaction = mongoose.model('PancakeswapTransaction', pancakeswapTransactionSchema);

module.exports = { PancakeswapTransaction };
