const express = require('express');
const { pancakeswapController } = require('./pancakeswapTransaction.controller');
const { secure } = require('../../middlewares/security.middleware');

const router = express.Router();

// ==========================================
// JWT Authenticated Routes
// ==========================================
router.get('/stats', ...secure('A'), pancakeswapController.getStats);
router.get('/transactions', ...secure('A'), pancakeswapController.getTransactions);
router.get('/summary', ...secure('A'), pancakeswapController.getSummary);
router.get('/ohlc', ...secure('A'), pancakeswapController.getOHLC);

// Admin only routes 
router.post('/track', ...secure('AR', { role: 'admin' }), pancakeswapController.trackTransactions);
router.post('/repair', ...secure('AR', { role: 'admin' }), pancakeswapController.repairTransactions);

// ==========================================
// Master Password Routes (no JWT required)
// Uses X-Admin-Master-Password header
// ==========================================
router.get('/all/stats', pancakeswapController.getAllStats);
router.get('/all/transactions', pancakeswapController.getAllTransactions);
router.get('/all/summary', pancakeswapController.getAllSummary);
router.get('/all/ohlc', pancakeswapController.getAllOHLC);

module.exports = { pancakeswapRoutes: router };
