const mongoose = require('mongoose');

const attachmentSchema = new mongoose.Schema({
  filename: {
    type: String,
    required: true,
    trim: true,
  },
  path: {
    type: String,
    required: true,
    trim: true,
  },
  contentType: {
    type: String,
    required: true,
    trim: true,
  },
  size: {
    type: Number,
    required: true,
  },
}, { _id: false });

const commentSchema = new mongoose.Schema({
  role: {
    type: String,
    required: true,
    trim: true,
  },
  message: {
    type: String,
    required: true,
    trim: true,
  },
  attachments: {
    type: [mongoose.Schema.Types.Mixed],
    required: true,
    default: [],
  },
  createdAt: {
    type: Date,
    required: true,
    default: Date.now,
  },
});

const problemReportSchema = new mongoose.Schema(
  {
    username: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    userEmail: {
      type: String,
      required: true,
      trim: true,
    },
    title: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    details: {
      type: String,
      required: true,
      trim: true,
    },
    status: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    priority: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    attachments: {
      type: [attachmentSchema],
      required: true,
      default: [],
    },
    comments: {
      type: [commentSchema],
      required: true,
      default: [],
    },
    assignedTo: {
      type: mongoose.Schema.Types.Mixed,
      required: false,
      default: null,
    },
  },
  {
    timestamps: true,
    collection: 'problemReports',
  }
);

problemReportSchema.index({ username: 1, status: 1 });
problemReportSchema.index({ priority: 1, status: 1 });
problemReportSchema.index({ createdAt: -1 });

const ProblemReport = mongoose.model('ProblemReport', problemReportSchema);

module.exports = { ProblemReport };
