const mongoose = require("mongoose");

const productSchema = new mongoose.Schema(
	{
		name: {
			type: String,
			required: true,
			trim: true,
		},
		packageType: {
			type: String,
			required: true,
			enum: ["locked", "unlocked"],
		},
		lockPeriod: {
			type: {
				value: { type: Number, required: false },
				unit: { type: String, required: false },
			},
			required: false,
			default: null,
		},
		price: {
			type: {
				startUSD: { type: Number, required: false },
				increasePerSaleUSD: { type: Number, required: false },
				countForPriceIncrease: { type: Number, required: false },
				increaseSalePriceUSD: { type: Number, required: false },
				fixedUSD: { type: Number, required: false },
			},
			required: false,
			default: null,
		},
		referralBonusImmediate: {
			type: {
				firstGenPercent: { type: Number, required: true, default: 0 },
				secondGenPercent: { type: Number, required: false },
				othersGenPercent: { type: Number, required: false },
			},
			required: true,
		},
		referralBonusTargetFill: {
			type: {
				groupSize: { type: Number, required: false },
				bonusPerGroupUSD: { type: Number, required: false },
				tokenBased: { type: mongoose.Schema.Types.Mixed, required: false },
			},
			required: false,
			default: null,
		},
		userBonusCalculation: {
			type: {
				packageUSD: { type: Number, required: false },
				aprPercent: { type: Number, required: false },
				bonusPercent: { type: Number, required: false },
				lockPeriod: {
					type: {
						value: { type: Number, required: false },
						unit: { type: String, required: false },
					},
					required: false,
				},
				annualBonus: { type: Number, required: false },
			},
			required: true,
		},
		referralBonusCalculation: {
			type: {
				formula: { type: String, required: false },
				perDayPercent: {
					type: {
						firstGen: { type: Number, required: true },
						secondGen: { type: Number, required: false },
						othersGen: { type: Number, required: false },
					},
					required: true,
				},
				maxGeneration: { type: Number },
			},
			required: true,
		},
		bonusClaim: {
			type: {
				frequency: {
					type: String,
					required: true,
					enum: ["daily", "after_lock_period", "monthly"],
				},
			},
			required: true,
		},
		isActive: {
			type: Boolean,
			required: true,
			default: true,
		},
		hasMonthlyBonus: {
			type: Boolean,
			required: false,
			default: false,
		},
		hasMysteryBox: {
			type: Boolean,
			required: false,
			default: false,
		},
		maxSellsCount: {
			type: Number,
			required: false,
		},
		monthlyBonusPercent: {
			type: Number,
			required: false,
			default: 0,
		},
		startDate: {
			type: String,
			required: false,
		},
		packageId: {
			type: String,
			required: false,
		},
		reserveWalletAddress: {
			type: String,
			required: false,
			trim: true,
		},
		minPurchaseUsersForBonus: {
			type: Number,
			required: false,
			default: 1,
		},
		dynamicPricing: {
			type: {
				basePriceUSD: { type: Number, required: false },
				lastChecked: { type: Date, required: false },
				lastPriceUpdate: { type: Date, required: false },
				priceHistory: {
					type: [
						{
							price: { type: Number, required: true },
							soldCount: { type: Number, required: true },
							timestamp: { type: Date, required: true },
							reason: { type: String, required: false },
							isBasePriceEntry: { type: Boolean, required: false },
							priceIncrease: { type: Number, required: false },
							increasesApplied: { type: Number, required: false },
						},
					],
					required: false,
					default: [],
				},
			},
			required: false,
			default: null,
		},
	},
	{
		timestamps: true,
		collection: "products",
	},
);

productSchema.index({ packageType: 1 });
productSchema.index({ isActive: 1 });
productSchema.index({ name: 1 });

const Product = mongoose.model("Product", productSchema);

module.exports = { Product };
