const express = require("express");
const productController = require("./product.controller");
const { secure } = require("../../middlewares/security.middleware");

const router = express.Router();

// Public routes (with auth)
router.get("/", secure("AR"), productController.getAllProducts);
router.get("/user-counts", secure("AR"), productController.getPackageUserCounts);
router.get("/:id", secure("AR"), productController.getProductById);

// Admin routes
router.post("/", secure("AR", { role: "admin" }), productController.createProduct);
router.put("/:id", secure("AR", { role: "admin" }), productController.updateProduct);
router.put("/:id/status", secure("AR", { role: "admin" }), productController.toggleProductStatus);
router.delete("/:id", secure("AR", { role: "admin" }), productController.deleteProduct);

module.exports = router;
