const express = require('express');
const { purchaseController } = require('./purchase.controller');
const { secure } = require('../../middlewares/security.middleware');

const router = express.Router();

// Overview stats
router.get('/overview', ...secure('AR', { role: 'admin' }), purchaseController.getOverview);

// Purchase analytics
router.get('/analytics', ...secure('AR', { role: 'admin' }), purchaseController.getAnalytics);

// Purchase failures
router.get('/failures', ...secure('AR', { role: 'admin' }), purchaseController.getFailures);

// Purchase locks
router.get('/locks', ...secure('AR', { role: 'admin' }), purchaseController.getLocks);
router.delete('/locks', ...secure('AR', { role: 'admin' }), purchaseController.clearLocks);

// Successful purchases
router.get('/successes', ...secure('AR', { role: 'admin' }), purchaseController.getSuccesses);

// Get filtered packages by type
router.get('/filtered', ...secure('AR'), purchaseController.getFilteredPackages);

// Purchase package (POST)
// router.post('/', ...secure('ARNC'), purchaseController.purchasePackage);
router.post('/', ...secure('AR'), purchaseController.purchasePackage); // TEMPORARY: Disabled nonce check for testing

//check purchase status
router.get('/purchase-status', ...secure('AR'), purchaseController.getPurchaseStatus);

module.exports = { purchaseRoutes: router };
