const mongoose = require('mongoose');

const purchaseFailureSchema = new mongoose.Schema(
  {
    username: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    fromAddress: {
      type: String,
      required: true,
      trim: true,
    },
    packageId: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    quantity: {
      type: Number,
      required: true,
    },
    priceUSD: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    priceNTE: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    transactionHash: {
      type: String,
      required: true,
      trim: true,
    },
    timestamp: {
      type: Date,
      required: true,
      index: true,
    },
    errorType: {
      type: String,
      required: true,
      trim: true,
    },
    errorDetails: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    purchaseId: {
      type: String,
      trim: true,
    },
    packagesCreated: {
      type: Number,
    },
    transactionIds: {
      type: [String],
    },
    processingTime: {
      type: Number,
    },
    metadata: {
      traceId: {
        type: String,
        trim: true,
      },
    },
  },
  {
    timestamps: false,
    collection: 'purchase_failures',
  }
);

purchaseFailureSchema.index({ username: 1, timestamp: -1 });
purchaseFailureSchema.index({ packageId: 1, timestamp: -1 });

const PurchaseFailure = mongoose.model('PurchaseFailure', purchaseFailureSchema);

module.exports = { PurchaseFailure };
