const mongoose = require('mongoose');

const purchaseLockSchema = new mongoose.Schema(
  {
    packageId: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    purchaseId: {
      type: String,
      required: true,
      unique: true,
      trim: true,
    },
    username: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    quantity: {
      type: Number,
      required: true,
    },
    transactionHash: {
      type: String,
      required: true,
      trim: true,
    },
    status: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    expiresAt: {
      type: Date,
      required: true,
      index: true,
    },
    packagesCreated: {
      type: Number,
      required: true,
    },
    transactionIds: {
      type: [String],
    },
    completedAt: {
      type: Date,
    },
    failedAt: {
      type: Date,
    },
    error: {
      type: String,
      trim: true,
    },
    clientIP: {
      type: String,
      trim: true,
    },
    userAgent: {
      type: String,
      trim: true,
    },
  },
  {
    timestamps: true,
    collection: 'purchase_locks',
  }
);

purchaseLockSchema.index({ username: 1, status: 1 });
purchaseLockSchema.index({ packageId: 1, status: 1 });
purchaseLockSchema.index({ status: 1, expiresAt: 1 });

const PurchaseLock = mongoose.model('PurchaseLock', purchaseLockSchema);

module.exports = { PurchaseLock };
