const mongoose = require('mongoose');

const purchaseSuccessSchema = new mongoose.Schema(
  {
    purchaseId: {
      type: String,
      trim: true,
    },
    username: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    fromAddress: {
      type: String,
      required: true,
      trim: true,
    },
    packageId: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    quantity: {
      type: Number,
      required: true,
    },
    priceUSD: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    priceNTE: {
      type: mongoose.Schema.Types.Mixed,
      required: true,
    },
    transactionHash: {
      type: String,
      required: true,
      trim: true,
      index: true,
    },
    status: {
      type: String,
      required: true,
      trim: true,
    },
    timestamp: {
      type: Date,
      required: true,
      index: true,
    },
    duration: {
      type: Number,
      required: true,
    },
    packagesCreated: {
      type: Number,
    },
    bonusSuccessCount: {
      type: Number,
    },
    bonusFailureCount: {
      type: Number,
    },
    verification: {
      success: {
        type: Boolean,
        required: true,
      },
      allRecordsCreated: {
        type: Boolean,
        required: true,
      },
      completeness: {
        type: mongoose.Schema.Types.Mixed,
        required: true,
      },
      details: {
        type: mongoose.Schema.Types.Mixed,
        required: true,
      },
      error: {
        type: String,
        trim: true,
      },
    },
    metadata: {
      traceId: {
        type: String,
        trim: true,
      },
    },
  },
  {
    timestamps: false,
    collection: 'purchase_success',
  }
);

purchaseSuccessSchema.index({ username: 1, timestamp: -1 });
purchaseSuccessSchema.index({ packageId: 1, timestamp: -1 });

const PurchaseSuccess = mongoose.model('PurchaseSuccess', purchaseSuccessSchema);

module.exports = { PurchaseSuccess };
